/*******************************************************************
*
*  DESCRIPTION: Simulator::registerNewAtomics()
*
*  AUTHOR: Dieynaba Alpha Tall
*
*  EMAIL: alphadieynaba@yahoo.fr
*
*
*  DATE: 02/08/2009
*
*******************************************************************/

#include <modeladm.h>
#include <mainsimu.h>
#include <portadm.h> 
#include <port.h> 

/* New libraries are copied after this line */
#include "LightSensor.h"
#include "SensorController.h"
#include "MovementController.h"
#include "Motor.h"
#include "In2.h"
#include "Out2.h"
#include "Out3.h"


void MainSimulator::registerNewAtomics()
{

//New models are regsitered after this line
SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<LightSensor>() , "LightSensor" ) ;
SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<SensorController>() , "SensorController" ) ;
SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<MovementController>() , "MovementController" ) ;
SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<Motor>() , "MotorRight" ) ;
SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<Motor>() , "MotorLeft" ) ;

}

void MainSimulator::registerTopPorts() 
{
//Top model ports connected to hardware must be registered here 
  SinglePortAdm::Instance().registerPort( new In2("LIGHT_IN") );
  SinglePortAdm::Instance().registerPort( new Out2("MOVER_OUT") );
  SinglePortAdm::Instance().registerPort( new Out3("MOVEL_OUT") );

}
